/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.datapack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.przemyk.simpleplanes.datapack.PayloadEntry;

public class PlanePayloadReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    public static Map<Item, PayloadEntry> payloadEntries = new HashMap<Item, PayloadEntry>();

    public PlanePayloadReloadListener() {
        super(GSON, "plane_payload");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        payloadEntries.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            try {
                CompoundTag compoundTag;
                JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"top element");
                Item item = Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(jsonObject.get("item").getAsString())), "missing item");
                Block renderBlock = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(jsonObject.get("block").getAsString())), "missing block");
                EntityType dropSpawnEntity = Objects.requireNonNull((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(jsonObject.get("entity").getAsString())), "missing entity");
                if (jsonObject.has("entity_nbt")) {
                    String tag = GsonHelper.m_13805_((JsonElement)jsonObject.get("entity_nbt"), (String)"entity_nbt");
                    System.out.println(tag);
                    compoundTag = TagParser.m_129359_((String)tag);
                } else {
                    compoundTag = new CompoundTag();
                }
                payloadEntries.put(item, new PayloadEntry(item, renderBlock, dropSpawnEntity, compoundTag));
            }
            catch (Exception e) {
                LOGGER.error("Parsing error loading plane payload {}", (Object)entry.getKey(), (Object)e);
            }
        }
    }
}

